
/*	Hugh Fisher 2004.

	Vertex shader to do heightfield rendering, this
	time with dynamic data modification and lighting.
							*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <math.h>

#include <time.h>
#include <sys/time.h>

#include <GL/glut.h>
#include <GL/glext.h>

#include "utility.h"
#include "glUtils.h"

#include "map.h"
#include "globals.h"
#include "inputs.h"
#include "oglRender.h"
#include "shader.h"

SharedData *	App;

#define cmdStdOpenGL	 1
#define cmdVertexShader	 2
#define cmdExit		99

static int	Menu;

static int	Wave;

/****		Drawing the world		****/

static void setViewpoint ()
{
  gluLookAt(0, App->viewHeight, App->viewDist,
  	    0, App->viewHeight - 0.25, App->viewDist - 1,
	    0, 1, 0);
}

static void display ()
{
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glPushMatrix();
  glLoadIdentity();
  
  setViewpoint();
  
  glPushMatrix();
    glRotatef(App->viewRot, 0, 1, 0);
    if (App->useShader)
      RenderShader(&App->map);
    else
      RenderGL(&App->map);
  glPopMatrix();
  
  glPopMatrix();  
  CheckGL();
  glutSwapBuffers();
}

static void resize (int width, int height)
{
  GLfloat aspect;

  App->winWidth  = width;
  App->winHeight = height;
  
  glMatrixMode(GL_PROJECTION);
  glViewport(0, 0, width, height);
  glLoadIdentity();
  aspect = (float)width / (float)height;
  gluPerspective(60.0, aspect, App->winNear, App->winFar);
  glMatrixMode(GL_MODELVIEW);
}


static void menuChoice (int item)
{
  switch (item) {
    case cmdStdOpenGL:
      App->useShader = FALSE;
      printf("Standard OpenGL\n");
      break;
    case cmdVertexShader:
      App->useShader = TRUE;
      printf("Vertex shader\n");
      break;
    case cmdExit:
      exit(0);
      break;
    default:
      break;
  }
}


/****		Main control		****/


static void initApp ()
{
  App->winNear	  = 1;
  App->winFar	  = 5000;
  App->animate	  = TRUE;
  App->useShader  = FALSE;
  App->recalc	  = TRUE;
  
  Wave = 1;
  
  glClearColor(0, 0, 0, 0); 
  glEnable(GL_DEPTH_TEST);

  InitRenderGL();
  InitShader();
  /* Make sure we did everything right */
  CheckGL();
  
  Menu = glutCreateMenu(menuChoice);
  glutSetMenu(Menu);
  glutAddMenuEntry("OpenGL render", cmdStdOpenGL);
  glutAddMenuEntry("Vertex shader", cmdVertexShader);
  glutAddMenuEntry("----", 0);
  glutAddMenuEntry("Exit", cmdExit);
  glutAttachMenu(GLUT_RIGHT_BUTTON);
  
  App->map.groundScale = 4;
  ReadDefaultMap(&App->map);
}

static void processArgs (int argc, char * argv[])
{
  int i;
  char * arg;
  
  i = 1;
  while (i < argc) {
    arg = argv[i];
    if (arg[0] != '-')
      App->map.name = strdup(arg);
    else if (strcasecmp(arg, "-w") == 0) {
      i ++;
      App->map.width = atoi(argv[i]);
    } else if (strcasecmp(arg, "-d") == 0) {
      i ++;
      App->map.depth = atoi(argv[i]);
    } else
      fprintf(stderr, "Unrecognised option: %s\n", arg);
    i ++;
  }
}

static void idle ()
{
  if (App->animate) {
    App->viewRot += 0.1;
    if (App->viewRot >= 360)
      App->viewRot = 0;
    Wave = (Wave + 1) % App->map.depth;
    RippleMap(&App->map, Wave, 16, 32);
    App->recalc = TRUE;
  }
  glutPostRedisplay();
}

int main (int argc, char * argv[])
{
  glutInit(&argc, argv);
  glutInitDisplayMode(GLUT_DOUBLE | GLUT_DEPTH | GLUT_RGBA);

  App = New(sizeof(SharedData));
   
  glutInitWindowSize(800, 600);
  glutInitWindowPosition(100, 75);
  glutCreateWindow("Surface normals vertex program");

  processArgs(argc, argv);
  initApp();
  PrintHelp();
  
  glutDisplayFunc(display);
  glutReshapeFunc(resize);
  glutIdleFunc(idle);
  glutKeyboardFunc(AsciiKey);
  glutSpecialFunc(SpecialKey);
  glutMouseFunc(MouseButton);
  glutMotionFunc(MouseMotion);
  
  glutMainLoop();
  return 0;	/* Keeps compiler happy */
}
