#ifndef _map_
#define _map_

/*	Data structure for heightmap	*/

typedef int MapValue;

typedef struct {
	int		width;
	int		depth;
	char *		name;
	MapValue * 	data;
	GLfloat		groundScale;
	GLfloat		heightScale;
	} MapRec;
	
extern void ReadMap (MapRec * map, char * fileName, int width, int depth);

extern void ReadDefaultMap (MapRec * map);

extern float GetMapValue (MapRec * map, int x, int z);
#define GetMap(map, x, z) ((map)->data[(z) * (map)->width + (x)])

/* Special effect: create a ripple in the map by lowering points
   to left of x up to dist away by -dy, increasing points on right.
   Indexes wrap around so by increasing x a wave flows across */

extern void RippleMap (MapRec * map, int x, int dist, int dy);

#endif
