
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <GL/glut.h>

#include "utility.h"
#include "glUtils.h"

#include "globals.h"

#include "map.h"

void ReadMap (MapRec * map, char * fileName, int width, int depth)
{
  FILE * input;
  int i, count;
  unsigned char * buf;

  map->name = strdup(fileName);
  
  map->width = width;
  map->depth = depth;
  
  count = map->width * map->depth;
  buf = New(count);
  map->data = New(count * sizeof(int));

  input = fopen(map->name, "rb");
  FailNull(input, "Cannot open map");

  if (fread(buf, 1, count, input) != count)
    Fail("Cannot read correct number of values from map");

  fclose(input);
  printf("Read %d bytes map data from %s\n", count, fileName);
  
  for (i = 0; i < count; i++)
    map->data[i] = buf[i];
  Free(buf);
  
  /* Check display parameters */
  if (map->groundScale <= 0)
    map->groundScale = 1;
  if (map->heightScale <= 0)
    map->heightScale = 1;
    
  App->winFar  = Max(map->width, map->depth) * 20.0 * map->groundScale;
  App->recalc = TRUE;
  if (App->viewDist == 0)
    App->viewDist = App->winFar / 15.0;
  if (App->viewHeight == 0)
    App->viewHeight = 300;
}

void ReadDefaultMap (MapRec * map)
{
  if (map->name != NULL && map->width > 0 && map->depth > 0)
    ReadMap(map, map->name, map->width, map->depth);
  else
    ReadMap(map, "map-128x128.dat", 128, 128);
  
}

float GetMapValue (MapRec * map, int x, int z)
{
  return map->data[z * map->width + x];
}

void RippleMap (MapRec * map, int x, int dist, int dy)
{
  int i, xIdx, z;
  
  for (i = 0; i < dist; i++) {
    xIdx = (x + i) % map->width;
    for (z = 0; z < map->depth; z++)
      map->data[z * map->width + xIdx] -= 1.0;
  }
  for (i = 0; i < dist; i++) {
    xIdx = (x + dist + i) % map->width;
    for (z = 0; z < map->depth; z++)
      map->data[z * map->width + xIdx] += 1.0;
  }
}
