#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <stdlib.h>

#include <GL/glut.h>

#include "utility.h"
#include "glUtils.h"

#include "globals.h"
#include "render.h"

#include "inputs.h"

/* States in mouse drag */
#define START	0
#define FREE	1

/* Minimum mouse movement to count as drag */
#define MINDIST	4

/* Used to track mouse motion */
static int	dragButton = -1;
static int	downX, downY;
static int  motion;	/* One state values */

/* Values saved at start of mouse motion */
static float	saveDist, saveRot;
	
static float wrap (float value, float limit)
{
  if (value >= limit)
    return 0;
  else if (value <= 0)
    return limit;
  else
    return value;
}

/****		Keyboard controls	****/

							
void AsciiKey (unsigned char key, int x, int y)
{
#define Delta 0.025
  key = toupper(key);
  
  switch (key) {
    case 27:	/* ESC */
	exit(0);
	break;
    case 'V':
        App->useShader = ! App->useShader;
	if (! App->useShader)
          printf("Standard OpenGL\n");
	else
	  printf("Vertex shader\n");
	break;
    case ' ':
        App->animate = ! App->animate;
	break;
    case 'A':
        App->map.groundScale *= (1.0 - Delta);
	App->recalc = TRUE;
	break;
    case 'D':
        App->map.groundScale *= (1.0 + Delta);
	App->recalc = TRUE;
	break;
    case 'S':
        App->map.heightScale *= (1.0 - Delta);
	App->recalc = TRUE;
	break;
    case 'W':
        App->map.heightScale *= (1.0 + Delta);
	App->recalc = TRUE;
	break;
    default:
    	break;
  }
  glutPostRedisplay();
#undef Delta
}

void SpecialKey (int key, int x, int y)
{
#define Delta 10.0
  switch(key) {
    case GLUT_KEY_UP:
	App->viewDist -= Delta;
    	break;
    case GLUT_KEY_DOWN:
        App->viewDist += Delta;
    	break;
    case GLUT_KEY_LEFT:
        App->viewRot = wrap(App->viewRot - 1.0, 360);
    	break;
    case GLUT_KEY_RIGHT:
        App->viewRot = wrap(App->viewRot + 1.0, 360);
    	break;
    case GLUT_KEY_PAGE_UP:
        App->viewHeight += Delta;
    	break;
    case GLUT_KEY_PAGE_DOWN:
        App->viewHeight -= Delta;
    	break;
    default:
    	break;
  }
  glutPostRedisplay();
#undef Delta
}

/****		Mouse handling		****/

/*  Dragging with the left button across the window rotates
    in the horizontal plane. Dragging up or down with the
    middle button zooms in or out. Left + right within minimum
	distance is same as middle                        */

void MouseButton (int button, int state, int x, int y)
{
  if (state == GLUT_DOWN && motion == START) {
	if (dragButton < 0)
      dragButton = button;
	/* Check for emulation */
	else if ((dragButton == GLUT_LEFT_BUTTON && button == GLUT_RIGHT_BUTTON) ||
			 (dragButton == GLUT_RIGHT_BUTTON && button == GLUT_LEFT_BUTTON))
	  dragButton = GLUT_MIDDLE_BUTTON;
	else
	  return; /* Drag already in progress, ignore it */
    downX = x;
    downY = y;
    /* Need to save view parameters at mouse down */
    saveDist = App->viewDist;
    saveRot  = App->viewRot;
  } else if (state == GLUT_UP) {
    dragButton = -1;	/* ie off */
	motion = START;
    downX  = 0;
    downY  = 0;
  }
}

void MouseMotion (int x, int y)
{
  float dx, dy;
  float max;
  
  /* Calc relative movement */
  dx = x - downX;
  dy = y - downY;

  /* Far enough to count? */
  if (fabs(dx) < MINDIST && fabs(dy) < MINDIST && motion == START)
	return;
  else
	motion = FREE;

  if (dragButton == GLUT_LEFT_BUTTON) {
    /* Rotation, horizontal plane only so no quarternions */
    max = 180.0;
    App->viewRot = wrap(saveRot + (dx / (float)App->winWidth * max), 360);
  } else if (dragButton == GLUT_MIDDLE_BUTTON) {
    /* Zoom in or out. Zooming in should be slower and more precise. */
    if (dy < 0)
      max = 1.0;
    else
      max = 4.0;
    App->viewDist = saveDist +
      		saveDist * (dy / (float)App->winHeight * max);
  }
  glutPostRedisplay();
}

void PrintHelp ()
{
  printf("\n");
  printf("V toggles vertex shader\n");
  printf("Space bar toggles rotation\n");
  printf("Up/down keys or middle mouse move in/out\n");
  printf("Left/right keys or left mouse rotate\n");
  printf("Page up/down keys move vertically\n");
  printf("A,D keys change horizontal scale\n");
  printf("S,W keys change vertical scale\n");
  printf("\n");
  
}

