#ifndef _map_
#define _map_

/*	data structure for heightmap	*/

typedef unsigned char MapValue;

typedef struct {
	int		width;
	int		depth;
	char *		name;
	MapValue * 	data;
	GLfloat		groundScale;
	GLfloat		heightScale;
	} MapRec;
	
extern char * MapShader;

extern void ReadMap (MapRec * map, char * fileName, int width, int depth);

extern void ReadDefaultMap (MapRec * map);

extern float GetMap (MapRec * map, int x, int z);

#endif
