
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <GL/glut.h>

#include "utility.h"
#include "glUtils.h"

#include "globals.h"

#include "map.h"

void ReadMap (MapRec * map, char * fileName, int width, int depth)
{
  FILE * input;
  int bytes;

  map->name = strdup(fileName);
  
  map->width = width;
  map->depth = depth;
  
  bytes = map->width * map->depth;
  map->data = New(bytes);

  input = fopen(map->name, "rb");
  FailNull(input, "Cannot open map");

  if (fread(map->data, 1, bytes, input) != bytes)
    Fail("Cannot read correct number of values from map");

  fclose(input);
  printf("Read %d bytes map data from %s\n", bytes, fileName);
  
  // Check display parameters
  if (map->groundScale <= 0)
    map->groundScale = 1;
  if (map->heightScale <= 0)
    map->heightScale = 1;
    
  App->winFar  = Max(map->width, map->depth) * 20.0 * map->groundScale;
  App->rescale = TRUE;
  if (App->viewDist == 0)
    App->viewDist = App->winFar / 10.0;
  if (App->viewHeight == 0)
    App->viewHeight = 300;
}

void ReadDefaultMap (MapRec * map)
{
  if (map->name != NULL && map->width > 0 && map->depth > 0)
    ReadMap(map, map->name, map->width, map->depth);
  else
    ReadMap(map, "map-512x512.dat", 512, 512);
  
}

float GetMap (MapRec * map, int x, int z)
{
  return map->data[z * map->width + x];
}
